from flask import Flask, request, send_file, render_template
import pandas as pd
import pdfplumber
import re
import os

app = Flask(__name__)

def extract_information(pdf_path):
    first_names = []
    last_names = []
    emails = []

    with pdfplumber.open(pdf_path) as pdf:
        for page in pdf.pages:
            text = page.extract_text()
            matches = re.findall(r'([A-Za-z]+)\s+([A-Za-z]+)\s+(\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b)', text)
            for match in matches:
                first_names.append(match[0])
                last_names.append(match[1])
                emails.append(match[2])

    df = pd.DataFrame({
        'First Name': first_names,
        'Last Name': last_names,
        'Email': emails
    })

    return df

@app.route('/')
def upload_file():
    return render_template('upload.html')

@app.route('/uploader', methods=['GET', 'POST'])
def uploader():
    if request.method == 'POST':
        file = request.files['file']
        if file and file.filename.endswith('.pdf'):
            file_path = os.path.join('/tmp', file.filename)
            file.save(file_path)

            df = extract_information(file_path)
            output_csv_path = os.path.join('/tmp', 'output.csv')
            df.to_csv(output_csv_path, index=False)

            return send_file(output_csv_path, as_attachment=True, download_name='output.csv')

if __name__ == "__main__":
    app.run(debug=True, host='0.0.0.0')
